<?php

namespace App\Http\Controllers;

use App\Models\Prescription;
use App\Models\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PatientController extends Controller
{
    public function dashboard()
    {
        $user = Auth::user();
        
        // Find patient by user_id or email
        $patient = \App\Models\Patient::where('user_id', $user->id)
            ->orWhere('email', $user->email)
            ->first();

        if (!$patient) {
            return view('patient.not-found');
        }

        $prescriptions = Prescription::where('patient_id', $patient->id)
            ->with(['doctor', 'items', 'appointment'])
            ->latest()
            ->get();

        $appointments = Appointment::where('patient_id', $patient->id)
            ->with(['doctor', 'branch', 'pharmacist'])
            ->latest()
            ->get();

        return view('patient.dashboard', compact('patient', 'prescriptions', 'appointments'));
    }

    public function prescriptions()
    {
        $user = Auth::user();
        $patient = \App\Models\Patient::where('user_id', $user->id)
            ->orWhere('email', $user->email)
            ->first();

        if (!$patient) {
            abort(404, 'Patient record not found.');
        }

        $prescriptions = Prescription::where('patient_id', $patient->id)
            ->with(['doctor', 'items', 'appointment'])
            ->latest()
            ->get();

        return view('patient.prescriptions', compact('prescriptions', 'patient'));
    }

    public function appointments()
    {
        $user = Auth::user();
        $patient = \App\Models\Patient::where('user_id', $user->id)
            ->orWhere('email', $user->email)
            ->first();

        if (!$patient) {
            abort(404, 'Patient record not found.');
        }

        $appointments = Appointment::where('patient_id', $patient->id)
            ->with(['doctor', 'branch', 'pharmacist', 'vitals'])
            ->latest()
            ->get();

        return view('patient.appointments', compact('appointments', 'patient'));
    }
}

